#include "KMotionDef.h"
#include "Driver\Defines.c"

#define Z_UP_AFTER_TOUCH 1.0 //Move up this amount in Inches after tool touch 
#define Offset_FromTouch 1.85 //if you don't want the dro set to zero
#define TOUCH_PROBE_PIN 17
double CountsPerInchZ;

#define GATH_OFF 0

int DoPC(int cmd);
int DoPCInt(int cmd, int i);
int MDI(char *s);
int DoPCFloat(int cmd, float f);

float saveaccel,savejerk;
double touchPos;

double offsetFromFirstTool;
double offsetFromPartZero;
float newDRO;

//-------------------------------------------------------
//-------------------------------------------------------
main()
{
	CountsPerInchZ = persist.UserData[ZSPI]; //get count

	// Save current Accel/Jerk
	saveaccel=chan[Z].Accel;
	savejerk=chan[Z].Jerk;

	// Set Accel/Jerk to Very fast
	chan[Z].Accel = 1000000000;
	chan[Z].Jerk = 1000000000;

	// Move Down
	Jog(Z,-5000);

	// Waite for Touch Probe hit
	while(ReadBit(TOUCH_PROBE_PIN))
	{
		if (CheckDone(Z))
			break;
	}
	touchPos = chan[Z].Position;	// Record position

	if (!ReadBit(ESTOP_SW)) return;

	Jog(Z, 0);
	
	// Restore saved Accel/Jerk
	chan[Z].Accel = saveaccel;
	chan[Z].Jerk = savejerk;
	
	Move(Z, touchPos);
	while(!CheckDone(Z));

	newDRO = Offset_FromTouch;
	
	//printf("%f, %f, %f\n", newDRO, offsetFromPartZero, offsetFromFirstTool);
	
	// Set New DRO Z Height
	DoPCFloat(PC_COMM_SET_Z, newDRO);

	Delay_sec(1.0);
	MoveRel(Z, Z_UP_AFTER_TOUCH * CountsPerInchZ);
}

//-------------------------------------------------------
//-------------------------------------------------------
// put the MDI string (Manual Data Input - GCode) in the 
// gather buffer and tell the App where it is
int MDI(char *s)
{
	char *p=(char *)gather_buffer+GATH_OFF*sizeof(int);
	int i;
	
	do // copy to gather buffer w offset 0
	{
		*p++ = *s++;
	}while (s[-1]);
	
	// issue the command an wait till it is complete
	// (or an error - such as busy)
	return DoPCInt(PC_COMM_MDI,GATH_OFF);
}


// Put a Float as a parameter and pass the command to the App
int DoPCFloat(int cmd, float f)
{
	int result;
	persist.UserData[PC_COMM_PERSIST+1] = *(int*)&f;
	return DoPC(cmd);
}

// Put an integer as a parameter and pass the command to the App
int DoPCInt(int cmd, int i)
{
	int result;
	persist.UserData[PC_COMM_PERSIST+1] = i;
	return DoPC(cmd);
}

// Pass a command to the PC and wait for it to handshake
// that it was received by either clearing the command
// or changing it to a negative error code
int DoPC(int cmd)
{
	int result;
	
	persist.UserData[PC_COMM_PERSIST]=cmd;
	
	do
	{
		WaitNextTimeSlice();	
	}while (result=persist.UserData[PC_COMM_PERSIST]>0);
	
	return result;
}